#version 330
#extension GL_EXT_gpu_shader4 : enable
// Blob RaymarchMod01.fsh  by   gunnarclovis

//https://www.shadertoy.com/view/lsVSWG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// whether or not to animate the raymarch
#define ANIMATED true
// 0 - 5 color modes
// 0 white 2D
// 1 light one-directional 2D shading
// 2 3D shading greyscale
// 3 inverted 3D shading
// 4 rainbow 3D color shading
// 5 final 3D color shading
#define COLOR_MODE 4
// whether or not to alter form vertically
#define VERTICAL true
// whether or not to alter form horizontally
#define HORIZONTAL true
// speed of animation, approach 0.0 to slow significantly
// anything >= ~3.0 causes decay
#define SPEED 2.5
// the y-scale, alter to cause extreme stretch deformations
#define Y_SCALE 0.15
// the x-scale, alter to cause extreme stretch deformations
#define X_SCALE 0.15
// the maximum s-value that determines the complexity of the form
// try high values like 50.0 or 150.0
#define MAX_S 15.0
// raymarch iterations
// higher values make the form sharper while taking more processing time
#define STEPS 64
#define EPS 0.01
#define FAR 10.0

float map(vec3 p)
{
    float v = SPEED * iTime;
    float r = 2.75 * (iMouse.xy == vec2(0.0) ? 0.55 : smoothstep(0.0, iResolution.y, iMouse.y)),
        s = MAX_S * (iMouse.xy == vec2(0.0) ? 0.75 : smoothstep(0.0, iResolution.x, iMouse.x));
    float py = HORIZONTAL ? p.y : 1.0,
        px = VERTICAL ? p.x : 1.0;
    
    if(ANIMATED)
    	r += Y_SCALE * cos(s * py + v) + X_SCALE * cos(s * px + v);
    else
        r += Y_SCALE * cos(s * py) + X_SCALE * cos(s * px);
    
    return length(p) - r;
}

vec3 grad(vec3 p)
{
    vec2 q = vec2(0.0, 0.05 * EPS);
    return vec3(map(p + q.yxx) - map(p - q.yxx),
               	map(p + q.xyx) - map(p - q.xyx),
               	map(p + q.xxy) - map(p - q.xxy));
}

vec3 shade(vec3 ro, vec3 rd, float t)
{
    if(COLOR_MODE == 0)
        return vec3(1.0);
    
    else if(COLOR_MODE == 1)
        return vec3(1.0) * dot(-rd, vec3(1.0));
        
    else if(COLOR_MODE == 2)
        return vec3(1.0) * dot(-rd, normalize(grad(ro + t * rd)));
        
    else if(COLOR_MODE == 3)
        return vec3(1.0) * (1.0 - dot(-rd, normalize(grad(ro + t * rd))));
        
    else if(COLOR_MODE == 4)
        return normalize(grad(ro + t * rd));
        
    else // 5+
        return vec3(0.3, 0.5, 0.7) * pow((1.0 - dot(-rd, normalize(grad(ro + t * rd)))), 3.0);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (-iResolution.xy + 2.0 * gl_FragCoord.xy) / iResolution.y;
    
    vec3 ro = vec3(0.0, 0.0, 2.5);
    vec3 rd = normalize(vec3(uv, -1.0));
    
    float t = 0.0, d = EPS;
    for(int i = 0; i < STEPS; ++i)
    {
        d = map(ro + t * rd);
        if(d < EPS || t > FAR) break;
        t += d;
    }
    
    // shading
    vec3 col = d < EPS ? shade(ro, rd, t) : mix(vec3(0.0), vec3(0.7, 0.5, 0.2), 2.0 - length(uv));
    
    col = pow(col, vec3(0.45));
    
	gl_FragColor = vec4(col, 1.0);
}